/* --COPYRIGHT--,BSD
 * Copyright (c) 2012, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * --/COPYRIGHT--*/
#include  <msp430x54xA.h>

#define DEVICE_ID_0		(0x1A04)
#define DEVICE_ID_1		(0x1A05)

struct s_TLV_Die_Record  {
  unsigned char die_record [10];
};

struct s_TLV_ADC_Cal_Data  {
  unsigned int adc_gain_factor;
  unsigned int adc_offset;
  unsigned int adc_ref15_factor; 
  unsigned int adc_ref15_30_temp;
  unsigned int adc_ref15_85_temp;
  unsigned int adc_ref25_factor; 
  unsigned int adc_ref25_30_temp;
  unsigned int adc_ref25_85_temp;
};

struct s_TLV_REF_Cal_Data  {
  unsigned int ref_ref15;
  unsigned int ref_ref20;
  unsigned int adc_ref25;
};

typedef enum 
{
  F5438 = 0,
  F5438A 
}device_t; 

/************************************************************
* function declaration
************************************************************/
void Get_TLV_info(unsigned char tag, unsigned char *length, unsigned int ** data_address);
device_t Get_Device_Type(void); 
